/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.gui.panes;

import com.google.common.collect.Maps;
import com.google.common.eventbus.Subscribe;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.ftb.data.LauncherStyle;
import net.ftb.data.ModPack;
import net.ftb.data.Settings;
import net.ftb.events.PackChangeEvent;
import net.ftb.gui.LaunchFrame;
import net.ftb.gui.dialogs.SearchDialog;
import net.ftb.locale.I18N;
import net.ftb.log.Logger;
import net.ftb.util.OSUtils;

public abstract class AbstractModPackPane
extends JPanel {
    JPanel packs;
    public ArrayList<JPanel> packPanels;
    public JScrollPane packsScroll;
    int numberOfPacks;
    JLabel typeLbl;
    JButton filter;
    JButton editModPack;
    JButton server;
    JButton privatePack;
    JComboBox version;
    int selectedPack = 0;
    boolean modPacksAdded = false;
    HashMap<Integer, ModPack> currentPacks = Maps.newHashMap();
    HashMap<Integer, Integer> packMapping = Maps.newHashMap();
    JEditorPane packInfo;
    public String origin = I18N.getLocaleString("MAIN_ALL");
    public String mcVersion = I18N.getLocaleString("MAIN_ALL");
    public String avaliability = I18N.getLocaleString("MAIN_ALL");
    public boolean loaded = false;
    JScrollPane infoScroll;
    final ActionListener al = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (AbstractModPackPane.this.version.getItemCount() > 0) {
                Settings.getSettings().setPackVer(String.valueOf(AbstractModPackPane.this.version.getSelectedItem()).equalsIgnoreCase("recommended") ? "Recommended Version" : String.valueOf(AbstractModPackPane.this.version.getSelectedItem()));
                Settings.getSettings().save();
            }
        }
    };

    public void addPack(ModPack pack) {
        if (!this.modPacksAdded) {
            this.modPacksAdded = true;
            this.packs.removeAll();
            this.packs.repaint();
        }
        final int packIndex = this.packPanels.size();
        JPanel p = new JPanel();
        p.setBounds(0, packIndex * 55, 420, 55);
        p.setLayout(null);
        JLabel logo = new JLabel(new ImageIcon(pack.getLogo()));
        logo.setBounds(6, 6, 42, 42);
        logo.setVisible(true);
        JTextArea filler = new JTextArea(pack.getName() + " (v" + pack.getVersion() + ") Minecraft Version " + pack.getMcVersion() + "\n" + "By " + pack.getAuthor());
        filler.setBorder(null);
        filler.setEditable(false);
        filler.setForeground(LauncherStyle.getCurrentStyle().tabPaneForeground);
        filler.setBounds(58, 6, 362, 42);
        filler.setBackground(LauncherStyle.getCurrentStyle().tabPaneBackground);
        MouseAdapter lin = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    LaunchFrame.getInstance().doLaunch();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                AbstractModPackPane.this.selectedPack = packIndex;
                AbstractModPackPane.this.updatePacks();
            }
        };
        p.addMouseListener(lin);
        filler.addMouseListener(lin);
        logo.addMouseListener(lin);
        p.add(filler);
        p.add(logo);
        this.packPanels.add(p);
        this.packs.add(p);
        this.packs.setMinimumSize(new Dimension(420, this.packPanels.size() * 55));
        this.packs.setPreferredSize(new Dimension(420, this.packPanels.size() * 55));
        if (pack.getDir().equalsIgnoreCase(this.getLastPack())) {
            this.selectedPack = packIndex;
        }
    }

    @Subscribe
    public void packChange(PackChangeEvent evt) {
        final PackChangeEvent event = evt;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (event.getType() == PackChangeEvent.TYPE.ADD) {
                    boolean doneWork = false;
                    if (event.getPacks() != null) {
                        for (ModPack p : event.getPacks()) {
                            if (!AbstractModPackPane.this.filterForTab(p)) continue;
                            AbstractModPackPane.this.addPack(p);
                            Logger.logInfo("Adding " + AbstractModPackPane.this.getPaneShortName() + " Pack: " + AbstractModPackPane.this.packPanels.size() + " (" + p.getName() + ")");
                            doneWork = true;
                            ++AbstractModPackPane.this.numberOfPacks;
                        }
                        if (doneWork) {
                            if (!AbstractModPackPane.this.currentPacks.isEmpty()) {
                                AbstractModPackPane.this.updateDatas();
                                AbstractModPackPane.this.updatePacks();
                            } else {
                                AbstractModPackPane.this.updateDatas();
                                AbstractModPackPane.this.updatePacks();
                            }
                            AbstractModPackPane.this.loaded = true;
                        }
                    }
                } else if (event.getType() == PackChangeEvent.TYPE.REMOVE) {
                    AbstractModPackPane.this.filterPacks();
                }
            }
        });
    }

    public void updateDatas() {
        this.currentPacks.clear();
        this.packMapping.clear();
        int counter = 0;
        for (ModPack pack : ModPack.getPackArray()) {
            if (!this.filterForTab(pack) || !this.mcVersionCheck(pack) || !this.avaliabilityCheck(pack) || !this.textSearch(pack)) continue;
            this.currentPacks.put(counter, pack);
            this.packMapping.put(counter, pack.getIndex());
            ++counter;
        }
    }

    public void filterPacks() {
        this.packPanels.clear();
        this.packs.removeAll();
        this.currentPacks.clear();
        this.packMapping.clear();
        int counter = 0;
        this.selectedPack = 0;
        this.packInfo.setText("");
        this.packs.repaint();
        for (ModPack pack : ModPack.getPackArray()) {
            if (!this.filterForTab(pack) || !this.mcVersionCheck(pack) || !this.avaliabilityCheck(pack) || !this.textSearch(pack)) continue;
            this.currentPacks.put(counter, pack);
            this.packMapping.put(counter, pack.getIndex());
            this.addPack(pack);
            ++counter;
        }
        this.updateDatas();
        this.updatePacks();
    }

    void updatePacks() {
        for (int i = 0; i < this.packPanels.size(); ++i) {
            if (this.selectedPack == i && this.getIndex() >= 0) {
                ModPack pack = ModPack.getPackArray().get(this.getIndex());
                if (pack == null) continue;
                String mods = "";
                if (pack.getMods() != null) {
                    mods = mods + "<p>This pack contains the following mods by default:</p><ul>";
                    for (String name : pack.getMods()) {
                        mods = mods + "<li>" + name + "</li>";
                    }
                    mods = mods + "</ul>";
                }
                this.packPanels.get(i).setBackground(UIManager.getColor("control").darker().darker());
                this.packPanels.get(i).setCursor(Cursor.getPredefinedCursor(0));
                File tempDir = new File(OSUtils.getCacheStorageLocation(), "ModPacks" + File.separator + pack.getDir());
                this.packInfo.setText("<html><img src='file:///" + tempDir.getPath() + File.separator + pack.getImageName() + "' width=400 height=200></img> <br>" + pack.getInfo() + mods);
                this.packInfo.setCaretPosition(0);
                if (ModPack.getSelectedPack(this.isFTB()).getServerUrl().equals("") || ModPack.getSelectedPack(this.isFTB()).getServerUrl() == null) {
                    this.server.setEnabled(false);
                } else {
                    this.server.setEnabled(true);
                }
                String tempVer = Settings.getSettings().getPackVer(pack.getDir());
                this.version.removeActionListener(this.al);
                this.version.removeAllItems();
                this.version.addItem("Recommended");
                if (pack.getOldVersions() != null) {
                    for (String s : pack.getOldVersions()) {
                        this.version.addItem(s);
                    }
                    this.version.setSelectedItem(tempVer);
                }
                this.version.addActionListener(this.al);
                continue;
            }
            this.packPanels.get(i).setBackground(UIManager.getColor("control"));
            this.packPanels.get(i).setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    public void updateFilterText() {
        String filterTextColor = LauncherStyle.getColorAsString(LauncherStyle.getCurrentStyle().filterTextColor);
        String filterInnerTextColor = LauncherStyle.getColorAsString(LauncherStyle.getCurrentStyle().filterInnerTextColor);
        String typeLblText = "<html><body>";
        typeLblText = typeLblText + "<strong><font color=rgb\"(" + filterTextColor + ")\">Filter: </strong></font>";
        typeLblText = typeLblText + "<font color=rgb\"(" + filterInnerTextColor + ")\">" + this.origin + "</font>";
        typeLblText = typeLblText + "<font color=rgb\"(" + filterTextColor + ")\"> / </font>";
        typeLblText = typeLblText + "<font color=rgb\"(" + filterInnerTextColor + ")\">" + this.mcVersion + "</font>";
        typeLblText = typeLblText + "</body></html>";
        this.typeLbl.setText(typeLblText);
    }

    public void updateFilter() {
        this.updateFilterText();
        this.filterPacks();
        LaunchFrame.getInstance().updateFooter();
    }

    int getIndex() {
        if (this.packMapping.get(this.selectedPack) == null) {
            return -1;
        }
        return this.packMapping.get(this.selectedPack);
    }

    public void updateLocale() {
        this.origin = I18N.getLocaleString("MAIN_ALL");
        this.mcVersion = I18N.getLocaleString("MAIN_ALL");
        this.avaliability = I18N.getLocaleString("MAIN_ALL");
        this.filter.setText(I18N.getLocaleString("FILTER_SETTINGS"));
        this.updateFilterText();
        this.editModPack.setText(I18N.getLocaleString("MODS_EDIT_PACK"));
        if (I18N.currentLocale == I18N.Locale.deDE) {
            this.editModPack.setBounds(290, 5, 120, 25);
            this.typeLbl.setBounds(115, 5, 165, 25);
        } else {
            this.editModPack.setBounds(300, 5, 110, 25);
            this.typeLbl.setBounds(115, 5, 175, 25);
        }
    }

    boolean avaliabilityCheck(ModPack pack) {
        return this.avaliability.equalsIgnoreCase(I18N.getLocaleString("MAIN_ALL")) || this.avaliability.equalsIgnoreCase(I18N.getLocaleString("FILTER_PUBLIC")) && !pack.isPrivatePack() || this.avaliability.equalsIgnoreCase(I18N.getLocaleString("FILTER_PRIVATE")) && pack.isPrivatePack();
    }

    boolean mcVersionCheck(ModPack pack) {
        return this.mcVersion.equalsIgnoreCase(I18N.getLocaleString("MAIN_ALL")) || this.mcVersion.equalsIgnoreCase(pack.getMcVersion());
    }

    boolean textSearch(ModPack pack) {
        String searchString = SearchDialog.lastPackSearch.toLowerCase();
        return searchString.isEmpty() || pack.getName().toLowerCase().contains(searchString) || pack.getAuthor().toLowerCase().contains(searchString);
    }

    abstract boolean filterForTab(ModPack var1);

    abstract String getLastPack();

    abstract String getPaneShortName();

    abstract boolean isFTB();
}

